"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the identity provider configuration of the specified fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.identity_provider_configuration.describe(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.identity_provider_configuration.describe fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_identity_provider_configuration",
        op_kwargs={"FleetArn": fleet_arn},
    )


async def update(
    hub,
    ctx,
    fleet_arn: str,
    identity_provider_type: str,
    identity_provider_saml_metadata: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the identity provider configuration for the fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        identity_provider_type(str): The type of identity provider.
        identity_provider_saml_metadata(str, optional): The SAML metadata document provided by the customer’s identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.identity_provider_configuration.update(
                ctx, fleet_arn=value, identity_provider_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.identity_provider_configuration.update fleet_arn=value, identity_provider_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="update_identity_provider_configuration",
        op_kwargs={
            "FleetArn": fleet_arn,
            "IdentityProviderType": identity_provider_type,
            "IdentityProviderSamlMetadata": identity_provider_saml_metadata,
        },
    )
