"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.

    Args:
        fleet_arn(str): The Amazon Resource Name (ARN) of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.fleet.metadata.describe(ctx, fleet_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.fleet.metadata.describe fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_fleet_metadata",
        op_kwargs={"FleetArn": fleet_arn},
    )


async def update(
    hub,
    ctx,
    fleet_arn: str,
    display_name: str = None,
    optimize_for_end_user_location: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates fleet metadata, such as DisplayName.

    Args:
        fleet_arn(str): The ARN of the fleet.
        display_name(str, optional): The fleet name to display. The existing DisplayName is unset if null is passed. Defaults to None.
        optimize_for_end_user_location(bool, optional): The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.fleet.metadata.update(ctx, fleet_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.fleet.metadata.update fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="update_fleet_metadata",
        op_kwargs={
            "FleetArn": fleet_arn,
            "DisplayName": display_name,
            "OptimizeForEndUserLocation": optimize_for_end_user_location,
        },
    )
