"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    fleet_name: str,
    display_name: str = None,
    optimize_for_end_user_location: bool = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.

    Args:
        fleet_name(str): A unique name for the fleet.
        display_name(str, optional): The fleet name to display. Defaults to None.
        optimize_for_end_user_location(bool, optional): The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to None.
        tags(Dict, optional):  The tags to add to the resource. A tag is a key-value pair. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.fleet.init.create(ctx, fleet_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.fleet.init.create fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="create_fleet",
        op_kwargs={
            "FleetName": fleet_name,
            "DisplayName": display_name,
            "OptimizeForEndUserLocation": optimize_for_end_user_location,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, fleet_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a fleet. Prevents users from accessing previously associated websites.

    Args:
        fleet_arn(str): The ARN of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.fleet.init.delete(ctx, fleet_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.fleet.init.delete fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="delete_fleet",
        op_kwargs={"FleetArn": fleet_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of fleets for the current account and Region.

    Args:
        next_token(str, optional): The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        max_results(int, optional): The maximum number of results to be included in the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.fleet.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.fleet.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="list_fleets",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
