"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    fleet_arn: str,
    domain_name: str,
    acm_certificate_arn: str,
    display_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Specifies a domain to be associated to Amazon WorkLink.

    Args:
        fleet_arn(str): The Amazon Resource Name (ARN) of the fleet.
        domain_name(str): The fully qualified domain name (FQDN).
        display_name(str, optional): The name to display. Defaults to None.
        acm_certificate_arn(str): The ARN of an issued ACM certificate that is valid for the domain being associated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.domain.init.associate(
                ctx, fleet_arn=value, domain_name=value, acm_certificate_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.domain.init.associate fleet_arn=value, domain_name=value, acm_certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="associate_domain",
        op_kwargs={
            "FleetArn": fleet_arn,
            "DomainName": domain_name,
            "DisplayName": display_name,
            "AcmCertificateArn": acm_certificate_arn,
        },
    )


async def describe(hub, ctx, fleet_arn: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the domain.

    Args:
        fleet_arn(str): The ARN of the fleet.
        domain_name(str): The name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.domain.init.describe(
                ctx, fleet_arn=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.domain.init.describe fleet_arn=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_domain",
        op_kwargs={"FleetArn": fleet_arn, "DomainName": domain_name},
    )


async def disassociate(hub, ctx, fleet_arn: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.

    Args:
        fleet_arn(str): The ARN of the fleet.
        domain_name(str): The name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.domain.init.disassociate(
                ctx, fleet_arn=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.domain.init.disassociate fleet_arn=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="disassociate_domain",
        op_kwargs={"FleetArn": fleet_arn, "DomainName": domain_name},
    )


async def list_all(
    hub, ctx, fleet_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of domains associated to a specified fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        next_token(str, optional): The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        max_results(int, optional): The maximum number of results to be included in the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.domain.init.list_all(ctx, fleet_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.domain.init.list_all fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="list_domains",
        op_kwargs={
            "FleetArn": fleet_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
