"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def restore(hub, ctx, fleet_arn: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Moves a domain to ACTIVE status if it was in the INACTIVE status.

    Args:
        fleet_arn(str): The ARN of the fleet.
        domain_name(str): The name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.domain.access.restore(
                ctx, fleet_arn=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.domain.access.restore fleet_arn=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="restore_domain_access",
        op_kwargs={"FleetArn": fleet_arn, "DomainName": domain_name},
    )


async def revoke(hub, ctx, fleet_arn: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Moves a domain to INACTIVE status if it was in the ACTIVE status.

    Args:
        fleet_arn(str): The ARN of the fleet.
        domain_name(str): The name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.domain.access.revoke(
                ctx, fleet_arn=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.domain.access.revoke fleet_arn=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="revoke_domain_access",
        op_kwargs={"FleetArn": fleet_arn, "DomainName": domain_name},
    )
