"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the device policy configuration for the specified fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.device.policy_configuration.describe(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.device.policy_configuration.describe fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_device_policy_configuration",
        op_kwargs={"FleetArn": fleet_arn},
    )


async def update(hub, ctx, fleet_arn: str, device_ca_certificate: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the device policy configuration for the fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        device_ca_certificate(str, optional): The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.device.policy_configuration.update(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.device.policy_configuration.update fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="update_device_policy_configuration",
        op_kwargs={"FleetArn": fleet_arn, "DeviceCaCertificate": device_ca_certificate},
    )
