"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_arn: str, device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about a user's device.

    Args:
        fleet_arn(str): The ARN of the fleet.
        device_id(str): A unique identifier for a registered user's device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.device.init.describe(
                ctx, fleet_arn=value, device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.device.init.describe fleet_arn=value, device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_device",
        op_kwargs={"FleetArn": fleet_arn, "DeviceId": device_id},
    )


async def list_all(
    hub, ctx, fleet_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of devices registered with the specified fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        next_token(str, optional): The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        max_results(int, optional): The maximum number of results to be included in the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.device.init.list_all(ctx, fleet_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.device.init.list_all fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="list_devices",
        op_kwargs={
            "FleetArn": fleet_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
