"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, fleet_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the networking configuration to access the internal websites associated with the specified fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.company_network_configuration.describe(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.company_network_configuration.describe fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_company_network_configuration",
        op_kwargs={"FleetArn": fleet_arn},
    )


async def update(
    hub, ctx, fleet_arn: str, vpc_id: str, subnet_ids: List, security_group_ids: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the company network configuration for the fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        vpc_id(str): The VPC with connectivity to associated websites.
        subnet_ids(List): The subnets used for X-ENI connections from Amazon WorkLink rendering containers.
        security_group_ids(List): The security groups associated with access to the provided subnets.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.company_network_configuration.update(
                ctx, fleet_arn=value, vpc_id=value, subnet_ids=value, security_group_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.company_network_configuration.update fleet_arn=value, vpc_id=value, subnet_ids=value, security_group_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="update_company_network_configuration",
        op_kwargs={
            "FleetArn": fleet_arn,
            "VpcId": vpc_id,
            "SubnetIds": subnet_ids,
            "SecurityGroupIds": security_group_ids,
        },
    )
