"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the configuration for delivering audit streams to the customer account.

    Args:
        fleet_arn(str): The ARN of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.audit_stream_configuration.describe(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.audit_stream_configuration.describe fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_audit_stream_configuration",
        op_kwargs={"FleetArn": fleet_arn},
    )


async def update(hub, ctx, fleet_arn: str, audit_stream_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the audit stream configuration for the fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        audit_stream_arn(str, optional): The ARN of the Amazon Kinesis data stream that receives the audit events. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.audit_stream_configuration.update(ctx, fleet_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.audit_stream_configuration.update fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="update_audit_stream_configuration",
        op_kwargs={"FleetArn": fleet_arn, "AuditStreamArn": audit_stream_arn},
    )
