"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def activate(hub, ctx, user_id: str, authentication_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Activates the specified user. Only active users can access Amazon WorkDocs.

    Args:
        user_id(str): The ID of the user.
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.user.activate(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.user.activate user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="activate_user",
        op_kwargs={"UserId": user_id, "AuthenticationToken": authentication_token},
    )


async def create(
    hub,
    ctx,
    username: str,
    given_name: str,
    surname: str,
    password: str,
    organization_id: str = None,
    email_address: str = None,
    time_zone_id: str = None,
    storage_rule: Dict = None,
    authentication_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.

    Args:
        organization_id(str, optional): The ID of the organization. Defaults to None.
        username(str): The login name of the user.
        email_address(str, optional): The email address of the user. Defaults to None.
        given_name(str): The given name of the user.
        surname(str): The surname of the user.
        password(str): The password of the user.
        time_zone_id(str, optional): The time zone ID of the user. Defaults to None.
        storage_rule(Dict, optional): The amount of storage for the user. Defaults to None.
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.user.create(
                ctx, username=value, given_name=value, surname=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.user.create username=value, given_name=value, surname=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="create_user",
        op_kwargs={
            "OrganizationId": organization_id,
            "Username": username,
            "EmailAddress": email_address,
            "GivenName": given_name,
            "Surname": surname,
            "Password": password,
            "TimeZoneId": time_zone_id,
            "StorageRule": storage_rule,
            "AuthenticationToken": authentication_token,
        },
    )


async def deactivate(hub, ctx, user_id: str, authentication_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.

    Args:
        user_id(str): The ID of the user.
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.user.deactivate(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.user.deactivate user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="deactivate_user",
        op_kwargs={"UserId": user_id, "AuthenticationToken": authentication_token},
    )


async def delete(hub, ctx, user_id: str, authentication_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified user from a Simple AD or Microsoft AD directory.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials. Defaults to None.
        user_id(str): The ID of the user.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.user.delete(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.user.delete user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_user",
        op_kwargs={"AuthenticationToken": authentication_token, "UserId": user_id},
    )


async def describe_all(
    hub,
    ctx,
    authentication_token: str = None,
    organization_id: str = None,
    user_ids: str = None,
    query: str = None,
    include: str = None,
    order: str = None,
    sort: str = None,
    marker: str = None,
    limit: int = None,
    fields: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified users. You can describe all users or filter the results (for example, by status or organization). By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response includes a marker that you can use to request the next set of results.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        organization_id(str, optional): The ID of the organization. Defaults to None.
        user_ids(str, optional): The IDs of the users. Defaults to None.
        query(str, optional): A query to filter users by user name. Defaults to None.
        include(str, optional): The state of the users. Specify "ALL" to include inactive users. Defaults to None.
        order(str, optional): The order for the results. Defaults to None.
        sort(str, optional): The sorting criteria. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items to return. Defaults to None.
        fields(str, optional): A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.user.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.user.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_users",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "OrganizationId": organization_id,
            "UserIds": user_ids,
            "Query": query,
            "Include": include,
            "Order": order,
            "Sort": sort,
            "Marker": marker,
            "Limit": limit,
            "Fields": fields,
        },
    )


async def update(
    hub,
    ctx,
    user_id: str,
    authentication_token: str = None,
    given_name: str = None,
    surname: str = None,
    type_: str = None,
    storage_rule: Dict = None,
    time_zone_id: str = None,
    locale: str = None,
    grant_poweruser_privileges: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        user_id(str): The ID of the user.
        given_name(str, optional): The given name of the user. Defaults to None.
        surname(str, optional): The surname of the user. Defaults to None.
        type_(str, optional): The type of the user. Defaults to None.
        storage_rule(Dict, optional): The amount of storage for the user. Defaults to None.
        time_zone_id(str, optional): The time zone ID of the user. Defaults to None.
        locale(str, optional): The locale of the user. Defaults to None.
        grant_poweruser_privileges(str, optional): Boolean value to determine whether the user is granted Poweruser privileges. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.user.update(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.user.update user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="update_user",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "UserId": user_id,
            "GivenName": given_name,
            "Surname": surname,
            "Type": type_,
            "StorageRule": storage_rule,
            "TimeZoneId": time_zone_id,
            "Locale": locale,
            "GrantPoweruserPrivileges": grant_poweruser_privileges,
        },
    )
