"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, authentication_token: str, limit: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the current user's special folders; the RootFolder and the RecycleBin. RootFolder is the root of user's files and folders and RecycleBin is the root of recycled items. This is not a valid action for SigV4 (administrative API) clients. This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see Authentication and Access Control for User Applications in the Amazon WorkDocs Developer Guide.

    Args:
        authentication_token(str): Amazon WorkDocs authentication token.
        limit(int, optional): The maximum number of items to return. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.root_folder.describe_all(
                ctx, authentication_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.root_folder.describe_all authentication_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_root_folders",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "Limit": limit,
            "Marker": marker,
        },
    )
