"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(
    hub,
    ctx,
    resource_id: str,
    principals: List,
    authentication_token: str = None,
    notification_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if the principals already have different permissions.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        resource_id(str): The ID of the resource.
        principals(List): The users, groups, or organization being granted permission.
        notification_options(Dict, optional): The notification options. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.resource.permission.add(
                ctx, resource_id=value, principals=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.resource.permission.add resource_id=value, principals=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="add_resource_permissions",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "ResourceId": resource_id,
            "Principals": principals,
            "NotificationOptions": notification_options,
        },
    )


async def describe_all(
    hub,
    ctx,
    resource_id: str,
    authentication_token: str = None,
    principal_id: str = None,
    limit: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the permissions of a specified resource.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        resource_id(str): The ID of the resource.
        principal_id(str, optional): The ID of the principal to filter permissions by. Defaults to None.
        limit(int, optional): The maximum number of items to return with this call. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.resource.permission.describe_all(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.resource.permission.describe_all resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_resource_permissions",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "ResourceId": resource_id,
            "PrincipalId": principal_id,
            "Limit": limit,
            "Marker": marker,
        },
    )


async def remove(
    hub,
    ctx,
    resource_id: str,
    principal_id: str,
    authentication_token: str = None,
    principal_type: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Removes the permission for the specified principal from the specified resource.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        resource_id(str): The ID of the resource.
        principal_id(str): The principal ID of the resource.
        principal_type(str, optional): The principal type of the resource. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.resource.permission.remove(
                ctx, resource_id=value, principal_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.resource.permission.remove resource_id=value, principal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="remove_resource_permission",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "ResourceId": resource_id,
            "PrincipalId": principal_id,
            "PrincipalType": principal_type,
        },
    )
