"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    authentication_token: str = None,
    user_id: str = None,
    collection_type: str = None,
    limit: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a collection of resources, including folders and documents. The only CollectionType supported is SHARED_WITH_ME.

    Args:
        authentication_token(str, optional): The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        user_id(str, optional): The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials. Defaults to None.
        collection_type(str, optional): The collection type. Defaults to None.
        limit(int, optional): The maximum number of resources to return. Defaults to None.
        marker(str, optional): The marker for the next set of results. This marker was received from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.resource.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.resource.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="get_resources",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "UserId": user_id,
            "CollectionType": collection_type,
            "Limit": limit,
            "Marker": marker,
        },
    )
