"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, organization_id: str, endpoint: str, protocol: str, subscription_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must confirm the subscription. For more information, see Subscribe to Notifications in the Amazon WorkDocs Developer Guide.

    Args:
        organization_id(str): The ID of the organization.
        endpoint(str): The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with https.
        protocol(str): The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
        subscription_type(str): The notification type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.notification_subscription.create(
                ctx, organization_id=value, endpoint=value, protocol=value, subscription_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.notification_subscription.create organization_id=value, endpoint=value, protocol=value, subscription_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="create_notification_subscription",
        op_kwargs={
            "OrganizationId": organization_id,
            "Endpoint": endpoint,
            "Protocol": protocol,
            "SubscriptionType": subscription_type,
        },
    )


async def delete(hub, ctx, subscription_id: str, organization_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified subscription from the specified organization.

    Args:
        subscription_id(str): The ID of the subscription.
        organization_id(str): The ID of the organization.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.notification_subscription.delete(
                ctx, subscription_id=value, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.notification_subscription.delete subscription_id=value, organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_notification_subscription",
        op_kwargs={
            "SubscriptionId": subscription_id,
            "OrganizationId": organization_id,
        },
    )


async def describe_all(
    hub, ctx, organization_id: str, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the specified notification subscriptions.

    Args:
        organization_id(str): The ID of the organization.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.notification_subscription.describe_all(
                ctx, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.notification_subscription.describe_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_notification_subscriptions",
        op_kwargs={"OrganizationId": organization_id, "Marker": marker, "Limit": limit},
    )
