"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub, ctx, resource_id: str, labels: List, authentication_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified list of labels to the given resource (a document or folder)

    Args:
        resource_id(str): The ID of the resource.
        labels(List): List of labels to add to the resource.
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.label.create_multiple(
                ctx, resource_id=value, labels=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.label.create_multiple resource_id=value, labels=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="create_labels",
        op_kwargs={
            "ResourceId": resource_id,
            "Labels": labels,
            "AuthenticationToken": authentication_token,
        },
    )


async def delete_multiple(
    hub,
    ctx,
    resource_id: str,
    authentication_token: str = None,
    labels: List = None,
    delete_all: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified list of labels from a resource.

    Args:
        resource_id(str): The ID of the resource.
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        labels(List, optional): List of labels to delete from the resource. Defaults to None.
        delete_all(bool, optional): Flag to request removal of all labels from the specified resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.label.delete_multiple(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.label.delete_multiple resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_labels",
        op_kwargs={
            "ResourceId": resource_id,
            "AuthenticationToken": authentication_token,
            "Labels": labels,
            "DeleteAll": delete_all,
        },
    )
