"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    search_query: str,
    authentication_token: str = None,
    organization_id: str = None,
    marker: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the groups specified by the query. Groups are defined by the underlying Active Directory.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        search_query(str): A query to describe groups by group name.
        organization_id(str, optional): The ID of the organization. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.group.describe_all(ctx, search_query=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.group.describe_all search_query=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_groups",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "SearchQuery": search_query,
            "OrganizationId": organization_id,
            "Marker": marker,
            "Limit": limit,
        },
    )
