"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, parent_folder_id: str, authentication_token: str = None, name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a folder with the specified name and parent folder.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        name(str, optional): The name of the new folder. Defaults to None.
        parent_folder_id(str): The ID of the parent folder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.folder.init.create(ctx, parent_folder_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.folder.init.create parent_folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="create_folder",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "Name": name,
            "ParentFolderId": parent_folder_id,
        },
    )


async def delete(hub, ctx, folder_id: str, authentication_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Permanently deletes the specified folder and its contents.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        folder_id(str): The ID of the folder.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.folder.init.delete(ctx, folder_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.folder.init.delete folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_folder",
        op_kwargs={"AuthenticationToken": authentication_token, "FolderId": folder_id},
    )


async def get(
    hub,
    ctx,
    folder_id: str,
    authentication_token: str = None,
    include_custom_metadata: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the metadata of the specified folder.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        folder_id(str): The ID of the folder.
        include_custom_metadata(bool, optional): Set to TRUE to include custom metadata in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.folder.init.get(ctx, folder_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.folder.init.get folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="get_folder",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "FolderId": folder_id,
            "IncludeCustomMetadata": include_custom_metadata,
        },
    )


async def update(
    hub,
    ctx,
    folder_id: str,
    authentication_token: str = None,
    name: str = None,
    parent_folder_id: str = None,
    resource_state: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the specified attributes of the specified folder. The user must have access to both the folder and its parent folder, if applicable.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        folder_id(str): The ID of the folder.
        name(str, optional): The name of the folder. Defaults to None.
        parent_folder_id(str, optional): The ID of the parent folder. Defaults to None.
        resource_state(str, optional): The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.folder.init.update(ctx, folder_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.folder.init.update folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="update_folder",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "FolderId": folder_id,
            "Name": name,
            "ParentFolderId": parent_folder_id,
            "ResourceState": resource_state,
        },
    )
