"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(
    hub, ctx, folder_id: str, authentication_token: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the contents of the specified folder.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        folder_id(str): The ID of the folder.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.folder.content.delete_multiple(ctx, folder_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.folder.content.delete_multiple folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_folder_contents",
        op_kwargs={"AuthenticationToken": authentication_token, "FolderId": folder_id},
    )


async def describe_all(
    hub,
    ctx,
    folder_id: str,
    authentication_token: str = None,
    sort: str = None,
    order: str = None,
    limit: int = None,
    marker: str = None,
    type_: str = None,
    include: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the contents of the specified folder, including its documents and subfolders. By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more results, the response includes a marker that you can use to request the next set of results. You can also request initialized documents.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        folder_id(str): The ID of the folder.
        sort(str, optional): The sorting criteria. Defaults to None.
        order(str, optional): The order for the contents of the folder. Defaults to None.
        limit(int, optional): The maximum number of items to return with this call. Defaults to None.
        marker(str, optional): The marker for the next set of results. This marker was received from a previous call. Defaults to None.
        type_(str, optional): The type of items. Defaults to None.
        include(str, optional): The contents to include. Specify "INITIALIZED" to include initialized documents. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.folder.content.describe_all(ctx, folder_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.folder.content.describe_all folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_folder_contents",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "FolderId": folder_id,
            "Sort": sort,
            "Order": order,
            "Limit": limit,
            "Marker": marker,
            "Type": type_,
            "Include": include,
        },
    )
