"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def abort(
    hub, ctx, document_id: str, version_id: str, authentication_token: str = None
) -> None:
    r"""
    **Autogenerated function**

    Aborts the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload. The client should make this call only when it no longer intends to upload the document version, or fails to do so.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        version_id(str): The ID of the version.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.version.upload.abort(
                ctx, document_id=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.version.upload.abort document_id=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="abort_document_version_upload",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "VersionId": version_id,
        },
    )


async def initiate(
    hub,
    ctx,
    parent_folder_id: str,
    authentication_token: str = None,
    id_: str = None,
    name: str = None,
    content_created_timestamp: str = None,
    content_modified_timestamp: str = None,
    content_type: str = None,
    document_size_in_bytes: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new document object and version object. The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when creating a new version of an existing document. This is the first step to upload a document. Next, upload the document to the URL returned from the call, and then call UpdateDocumentVersion. To cancel the document upload, call AbortDocumentVersionUpload.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        id_(str, optional): The ID of the document. Defaults to None.
        name(str, optional): The name of the document. Defaults to None.
        content_created_timestamp(str, optional): The timestamp when the content of the document was originally created. Defaults to None.
        content_modified_timestamp(str, optional): The timestamp when the content of the document was modified. Defaults to None.
        content_type(str, optional): The content type of the document. Defaults to None.
        document_size_in_bytes(int, optional): The size of the document, in bytes. Defaults to None.
        parent_folder_id(str): The ID of the parent folder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.version.upload.initiate(
                ctx, parent_folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.version.upload.initiate parent_folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="initiate_document_version_upload",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "Id": id_,
            "Name": name,
            "ContentCreatedTimestamp": content_created_timestamp,
            "ContentModifiedTimestamp": content_modified_timestamp,
            "ContentType": content_type,
            "DocumentSizeInBytes": document_size_in_bytes,
            "ParentFolderId": parent_folder_id,
        },
    )
