"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    document_id: str,
    authentication_token: str = None,
    marker: str = None,
    limit: int = None,
    include: str = None,
    fields: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the document versions for the specified document. By default, only active versions are returned.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        limit(int, optional): The maximum number of versions to return with this call. Defaults to None.
        include(str, optional): A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions. Defaults to None.
        fields(str, optional): Specify "SOURCE" to include initialized versions and a URL for the source document. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.version.init.describe_all(
                ctx, document_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.version.init.describe_all document_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_document_versions",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "Marker": marker,
            "Limit": limit,
            "Include": include,
            "Fields": fields,
        },
    )


async def get(
    hub,
    ctx,
    document_id: str,
    version_id: str,
    authentication_token: str = None,
    fields: str = None,
    include_custom_metadata: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves version metadata for the specified document.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        version_id(str): The version ID of the document.
        fields(str, optional): A comma-separated list of values. Specify "SOURCE" to include a URL for the source document. Defaults to None.
        include_custom_metadata(bool, optional): Set this to TRUE to include custom metadata in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.version.init.get(
                ctx, document_id=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.version.init.get document_id=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="get_document_version",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "VersionId": version_id,
            "Fields": fields,
            "IncludeCustomMetadata": include_custom_metadata,
        },
    )


async def update(
    hub,
    ctx,
    document_id: str,
    version_id: str,
    authentication_token: str = None,
    version_status: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Changes the status of the document version to ACTIVE.  Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the client uploads the document to an S3-presigned URL returned by InitiateDocumentVersionUpload.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        version_id(str): The version ID of the document.
        version_status(str, optional): The status of the version. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.version.init.update(
                ctx, document_id=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.version.init.update document_id=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="update_document_version",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "VersionId": version_id,
            "VersionStatus": version_status,
        },
    )
