"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, document_id: str, authentication_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Permanently deletes the specified document and its associated metadata.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.init.delete(ctx, document_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.init.delete document_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_document",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
        },
    )


async def get(
    hub,
    ctx,
    document_id: str,
    authentication_token: str = None,
    include_custom_metadata: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details of a document.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        include_custom_metadata(bool, optional): Set this to TRUE to include custom metadata in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.init.get(ctx, document_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.init.get document_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="get_document",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "IncludeCustomMetadata": include_custom_metadata,
        },
    )


async def update(
    hub,
    ctx,
    document_id: str,
    authentication_token: str = None,
    name: str = None,
    parent_folder_id: str = None,
    resource_state: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the specified attributes of a document. The user must have access to both the document and its parent folder, if applicable.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        name(str, optional): The name of the document. Defaults to None.
        parent_folder_id(str, optional): The ID of the parent folder. Defaults to None.
        resource_state(str, optional): The resource state of the document. Only ACTIVE and RECYCLED are supported. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.document.init.update(ctx, document_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.document.init.update document_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="update_document",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "Name": name,
            "ParentFolderId": parent_folder_id,
            "ResourceState": resource_state,
        },
    )
