"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    resource_id: str,
    custom_metadata: Dict,
    authentication_token: str = None,
    version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more custom properties to the specified resource (a folder, document, or version).

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        resource_id(str): The ID of the resource.
        version_id(str, optional): The ID of the version, if the custom metadata is being added to a document version. Defaults to None.
        custom_metadata(Dict): Custom metadata in the form of name-value pairs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.custom_metadata.create(
                ctx, resource_id=value, custom_metadata=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.custom_metadata.create resource_id=value, custom_metadata=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="create_custom_metadata",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "ResourceId": resource_id,
            "VersionId": version_id,
            "CustomMetadata": custom_metadata,
        },
    )


async def delete(
    hub,
    ctx,
    resource_id: str,
    authentication_token: str = None,
    version_id: str = None,
    keys: List = None,
    delete_all: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes custom metadata from the specified resource.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        resource_id(str): The ID of the resource, either a document or folder.
        version_id(str, optional): The ID of the version, if the custom metadata is being deleted from a document version. Defaults to None.
        keys(List, optional): List of properties to remove. Defaults to None.
        delete_all(bool, optional): Flag to indicate removal of all custom metadata properties from the specified resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.custom_metadata.delete(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.custom_metadata.delete resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_custom_metadata",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "ResourceId": resource_id,
            "VersionId": version_id,
            "Keys": keys,
            "DeleteAll": delete_all,
        },
    )
