"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, authentication_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details of the current user for whom the authentication token was generated. This is not a valid action for SigV4 (administrative API) clients. This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see Authentication and Access Control for User Applications in the Amazon WorkDocs Developer Guide.

    Args:
        authentication_token(str): Amazon WorkDocs authentication token.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.current_user.get(ctx, authentication_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.current_user.get authentication_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="get_current_user",
        op_kwargs={"AuthenticationToken": authentication_token},
    )
