"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    document_id: str,
    version_id: str,
    text: str,
    authentication_token: str = None,
    parent_id: str = None,
    thread_id: str = None,
    visibility: str = None,
    notify_collaborators: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new comment to the specified document version.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        version_id(str): The ID of the document version.
        parent_id(str, optional): The ID of the parent comment. Defaults to None.
        thread_id(str, optional): The ID of the root comment in the thread. Defaults to None.
        text(str): The text of the comment.
        visibility(str, optional): The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors. Defaults to None.
        notify_collaborators(bool, optional): Set this parameter to TRUE to send an email out to the document collaborators after the comment is created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.comment.create(
                ctx, document_id=value, version_id=value, text=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.comment.create document_id=value, version_id=value, text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="create_comment",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "VersionId": version_id,
            "ParentId": parent_id,
            "ThreadId": thread_id,
            "Text": text,
            "Visibility": visibility,
            "NotifyCollaborators": notify_collaborators,
        },
    )


async def delete(
    hub,
    ctx,
    document_id: str,
    version_id: str,
    comment_id: str,
    authentication_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified comment from the document version.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        version_id(str): The ID of the document version.
        comment_id(str): The ID of the comment.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.comment.delete(
                ctx, document_id=value, version_id=value, comment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.comment.delete document_id=value, version_id=value, comment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="delete_comment",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "VersionId": version_id,
            "CommentId": comment_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    document_id: str,
    version_id: str,
    authentication_token: str = None,
    limit: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List all the comments for the specified document version.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        document_id(str): The ID of the document.
        version_id(str): The ID of the document version.
        limit(int, optional): The maximum number of items to return. Defaults to None.
        marker(str, optional): The marker for the next set of results. This marker was received from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.comment.describe_all(
                ctx, document_id=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.comment.describe_all document_id=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_comments",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "DocumentId": document_id,
            "VersionId": version_id,
            "Limit": limit,
            "Marker": marker,
        },
    )
