"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def remove(hub, ctx, resource_id: str, authentication_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Removes all the permissions from the specified resource.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        resource_id(str): The ID of the resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.all_resource_permission.remove(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.all_resource_permission.remove resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="remove_all_resource_permissions",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "ResourceId": resource_id,
        },
    )
