"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    authentication_token: str = None,
    start_time: str = None,
    end_time: str = None,
    organization_id: str = None,
    activity_types: str = None,
    resource_id: str = None,
    user_id: str = None,
    include_indirect_activities: bool = None,
    limit: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the user activities in a specified time period.

    Args:
        authentication_token(str, optional): Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API. Defaults to None.
        start_time(str, optional): The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp. Defaults to None.
        end_time(str, optional): The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp. Defaults to None.
        organization_id(str, optional): The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests. Defaults to None.
        activity_types(str, optional): Specifies which activity types to include in the response. If this field is left empty, all activity types are returned. Defaults to None.
        resource_id(str, optional): The document or folder ID for which to describe activity types. Defaults to None.
        user_id(str, optional): The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests. Defaults to None.
        include_indirect_activities(bool, optional): Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity). Defaults to None.
        limit(int, optional): The maximum number of items to return. Defaults to None.
        marker(str, optional): The marker for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workdoc.activity.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workdoc.activity.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workdocs",
        operation="describe_activities",
        op_kwargs={
            "AuthenticationToken": authentication_token,
            "StartTime": start_time,
            "EndTime": end_time,
            "OrganizationId": organization_id,
            "ActivityTypes": activity_types,
            "ResourceId": resource_id,
            "UserId": user_id,
            "IncludeIndirectActivities": include_indirect_activities,
            "Limit": limit,
            "Marker": marker,
        },
    )
