"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    workload_id: str,
    shared_with: str,
    permission_type: str,
    client_request_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a workload share. The owner of a workload can share it with other AWS accounts and IAM users in the same AWS Region. Shared access to a workload is not removed until the workload invitation is deleted. For more information, see Sharing a Workload in the AWS Well-Architected Tool User Guide.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        shared_with(str): The AWS account ID or IAM role with which the workload is shared.
        permission_type(str): Permission granted on a workload share.
        client_request_token(str): A unique case-sensitive string used to ensure that this request is idempotent (executes only once). You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.   This token is listed as required, however, if you do not specify it, the AWS SDKs automatically generate one for you. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the request will fail. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.share.create(
                ctx,
                workload_id=value,
                shared_with=value,
                permission_type=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.share.create workload_id=value, shared_with=value, permission_type=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="create_workload_share",
        op_kwargs={
            "WorkloadId": workload_id,
            "SharedWith": shared_with,
            "PermissionType": permission_type,
            "ClientRequestToken": client_request_token,
        },
    )


async def delete(
    hub, ctx, share_id: str, workload_id: str, client_request_token: str
) -> None:
    r"""
    **Autogenerated function**

    Delete a workload share.

    Args:
        share_id(str): The ID associated with the workload share.
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        client_request_token(str): A unique case-sensitive string used to ensure that this request is idempotent (executes only once). You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.   This token is listed as required, however, if you do not specify it, the AWS SDKs automatically generate one for you. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the request will fail. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.share.delete(
                ctx, share_id=value, workload_id=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.share.delete share_id=value, workload_id=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="delete_workload_share",
        op_kwargs={
            "ShareId": share_id,
            "WorkloadId": workload_id,
            "ClientRequestToken": client_request_token,
        },
    )


async def list_all(
    hub,
    ctx,
    workload_id: str,
    shared_with_prefix: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the workload shares associated with the workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        shared_with_prefix(str, optional): The AWS account ID or IAM role with which the workload is shared. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.share.list_all(ctx, workload_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.share.list_all workload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_workload_shares",
        op_kwargs={
            "WorkloadId": workload_id,
            "SharedWithPrefix": shared_with_prefix,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, share_id: str, workload_id: str, permission_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Update a workload share.

    Args:
        share_id(str): The ID associated with the workload share.
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        permission_type(str): Permission granted on a workload share.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.share.update(
                ctx, share_id=value, workload_id=value, permission_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.share.update share_id=value, workload_id=value, permission_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="update_workload_share",
        op_kwargs={
            "ShareId": share_id,
            "WorkloadId": workload_id,
            "PermissionType": permission_type,
        },
    )
