"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    workload_name: str,
    description: str,
    environment: str,
    review_owner: str,
    lenses: List,
    client_request_token: str,
    account_ids: List = None,
    aws_regions: List = None,
    non_aws_regions: List = None,
    pillar_priorities: List = None,
    architectural_design: str = None,
    industry_type: str = None,
    industry: str = None,
    notes: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new workload. The owner of a workload can share the workload with other AWS accounts and IAM users in the same AWS Region. Only the owner of a workload can delete it. For more information, see Defining a Workload in the AWS Well-Architected Tool User Guide.

    Args:
        workload_name(str): The name of the workload. The name must be unique within an account within a Region. Spaces and capitalization are ignored when checking for uniqueness.
        description(str): The description for the workload.
        environment(str): The environment for the workload.
        account_ids(List, optional): The list of AWS account IDs associated with the workload. Defaults to None.
        aws_regions(List, optional): The list of AWS Regions associated with the workload, for example, us-east-2, or ca-central-1. Defaults to None.
        non_aws_regions(List, optional):  The list of non-AWS Regions associated with the workload. Defaults to None.
        pillar_priorities(List, optional): The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its PillarReviewSummary$PillarId. Defaults to None.
        architectural_design(str, optional): The URL of the architectural design for the workload. Defaults to None.
        review_owner(str): The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.
        industry_type(str, optional): The industry type for the workload. If specified, must be one of the following:    Agriculture     Automobile     Defense     Design and Engineering     Digital Advertising     Education     Environmental Protection     Financial Services     Gaming     General Public Services     Healthcare     Hospitality     InfoTech     Justice and Public Safety     Life Sciences     Manufacturing     Media & Entertainment     Mining & Resources     Oil & Gas     Power & Utilities     Professional Services     Real Estate & Construction     Retail & Wholesale     Social Protection     Telecommunications     Travel, Transportation & Logistics     Other   . Defaults to None.
        industry(str, optional): The industry for the workload. Defaults to None.
        lenses(List): The list of lenses associated with the workload. Each lens is identified by its LensSummary$LensAlias.
        notes(str, optional): The notes associated with the workload. Defaults to None.
        client_request_token(str): A unique case-sensitive string used to ensure that this request is idempotent (executes only once). You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.   This token is listed as required, however, if you do not specify it, the AWS SDKs automatically generate one for you. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the request will fail. .
        tags(Dict, optional): The tags to be associated with the workload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.init.create(
                ctx,
                workload_name=value,
                description=value,
                environment=value,
                review_owner=value,
                lenses=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.init.create workload_name=value, description=value, environment=value, review_owner=value, lenses=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="create_workload",
        op_kwargs={
            "WorkloadName": workload_name,
            "Description": description,
            "Environment": environment,
            "AccountIds": account_ids,
            "AwsRegions": aws_regions,
            "NonAwsRegions": non_aws_regions,
            "PillarPriorities": pillar_priorities,
            "ArchitecturalDesign": architectural_design,
            "ReviewOwner": review_owner,
            "IndustryType": industry_type,
            "Industry": industry,
            "Lenses": lenses,
            "Notes": notes,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, workload_id: str, client_request_token: str) -> None:
    r"""
    **Autogenerated function**

    Delete an existing workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        client_request_token(str): A unique case-sensitive string used to ensure that this request is idempotent (executes only once). You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.   This token is listed as required, however, if you do not specify it, the AWS SDKs automatically generate one for you. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the request will fail. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.init.delete(
                ctx, workload_id=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.init.delete workload_id=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="delete_workload",
        op_kwargs={
            "WorkloadId": workload_id,
            "ClientRequestToken": client_request_token,
        },
    )


async def get(hub, ctx, workload_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get an existing workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.init.get(ctx, workload_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.init.get workload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="get_workload",
        op_kwargs={"WorkloadId": workload_id},
    )


async def list_all(
    hub,
    ctx,
    workload_name_prefix: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List workloads. Paginated.

    Args:
        workload_name_prefix(str, optional): An optional string added to the beginning of each workload name returned in the results. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_workloads",
        op_kwargs={
            "WorkloadNamePrefix": workload_name_prefix,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    workload_id: str,
    workload_name: str = None,
    description: str = None,
    environment: str = None,
    account_ids: List = None,
    aws_regions: List = None,
    non_aws_regions: List = None,
    pillar_priorities: List = None,
    architectural_design: str = None,
    review_owner: str = None,
    is_review_owner_update_acknowledged: bool = None,
    industry_type: str = None,
    industry: str = None,
    notes: str = None,
    improvement_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update an existing workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        workload_name(str, optional): The name of the workload. The name must be unique within an account within a Region. Spaces and capitalization are ignored when checking for uniqueness. Defaults to None.
        description(str, optional): The description for the workload. Defaults to None.
        environment(str, optional): The environment for the workload. Defaults to None.
        account_ids(List, optional): The list of AWS account IDs associated with the workload. Defaults to None.
        aws_regions(List, optional): The list of AWS Regions associated with the workload, for example, us-east-2, or ca-central-1. Defaults to None.
        non_aws_regions(List, optional):  The list of non-AWS Regions associated with the workload. Defaults to None.
        pillar_priorities(List, optional): The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its PillarReviewSummary$PillarId. Defaults to None.
        architectural_design(str, optional): The URL of the architectural design for the workload. Defaults to None.
        review_owner(str, optional): The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process. Defaults to None.
        is_review_owner_update_acknowledged(bool, optional): Flag indicating whether the workload owner has acknowledged that the Review owner field is required. If a Review owner is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added. Defaults to None.
        industry_type(str, optional): The industry type for the workload. If specified, must be one of the following:    Agriculture     Automobile     Defense     Design and Engineering     Digital Advertising     Education     Environmental Protection     Financial Services     Gaming     General Public Services     Healthcare     Hospitality     InfoTech     Justice and Public Safety     Life Sciences     Manufacturing     Media & Entertainment     Mining & Resources     Oil & Gas     Power & Utilities     Professional Services     Real Estate & Construction     Retail & Wholesale     Social Protection     Telecommunications     Travel, Transportation & Logistics     Other   . Defaults to None.
        industry(str, optional): The industry for the workload. Defaults to None.
        notes(str, optional): The notes associated with the workload. Defaults to None.
        improvement_status(str, optional): The improvement status for a workload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.workload.init.update(ctx, workload_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.workload.init.update workload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="update_workload",
        op_kwargs={
            "WorkloadId": workload_id,
            "WorkloadName": workload_name,
            "Description": description,
            "Environment": environment,
            "AccountIds": account_ids,
            "AwsRegions": aws_regions,
            "NonAwsRegions": non_aws_regions,
            "PillarPriorities": pillar_priorities,
            "ArchitecturalDesign": architectural_design,
            "ReviewOwner": review_owner,
            "IsReviewOwnerUpdateAcknowledged": is_review_owner_update_acknowledged,
            "IndustryType": industry_type,
            "Industry": industry,
            "Notes": notes,
            "ImprovementStatus": improvement_status,
        },
    )
