"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, workload_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    List the tags for a resource.

    Args:
        workload_arn(str): The ARN for the workload.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.tags_for_resource.list(ctx, workload_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.tags_for_resource.list workload_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_tags_for_resource",
        op_kwargs={"WorkloadArn": workload_arn},
    )
