"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    workload_name_prefix: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the workload invitations.

    Args:
        workload_name_prefix(str, optional): An optional string added to the beginning of each workload name returned in the results. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.share_invitation.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.share_invitation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_share_invitations",
        op_kwargs={
            "WorkloadNamePrefix": workload_name_prefix,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, share_invitation_id: str, share_invitation_action: str
) -> Dict:
    r"""
    **Autogenerated function**

    Update a workload invitation.

    Args:
        share_invitation_id(str): The ID assigned to the share invitation.
        share_invitation_action(str): Share invitation action taken by contributor.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.share_invitation.update(
                ctx, share_invitation_id=value, share_invitation_action=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.share_invitation.update share_invitation_id=value, share_invitation_action=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="update_share_invitation",
        op_kwargs={
            "ShareInvitationId": share_invitation_id,
            "ShareInvitationAction": share_invitation_action,
        },
    )
