"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, workload_arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to the specified resource.

    Args:
        workload_arn(str): The ARN for the workload.
        tags(Dict): The tags for the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.resource.tag(
                ctx, workload_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.resource.tag workload_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="tag_resource",
        op_kwargs={"WorkloadArn": workload_arn, "Tags": tags},
    )


async def untag(hub, ctx, workload_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes specified tags from a resource. To specify multiple tags, use separate tagKeys parameters, for example:  DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2

    Args:
        workload_arn(str): The ARN for the workload.
        tag_keys(List): A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.resource.untag(
                ctx, workload_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.resource.untag workload_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="untag_resource",
        op_kwargs={"WorkloadArn": workload_arn, "TagKeys": tag_keys},
    )
