"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, workload_id: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List lens notifications.

    Args:
        workload_id(str, optional): The ID assigned to the workload. This ID is unique within an AWS Region. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.notification.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.notification.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_notifications",
        op_kwargs={
            "WorkloadId": workload_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
