"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, workload_id: str, milestone_name: str, client_request_token: str
) -> Dict:
    r"""
    **Autogenerated function**

    Create a milestone for an existing workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        milestone_name(str): The name of the milestone in a workload. Milestone names must be unique within a workload.
        client_request_token(str): A unique case-sensitive string used to ensure that this request is idempotent (executes only once). You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.   This token is listed as required, however, if you do not specify it, the AWS SDKs automatically generate one for you. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the request will fail. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.milestone.create(
                ctx, workload_id=value, milestone_name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.milestone.create workload_id=value, milestone_name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="create_milestone",
        op_kwargs={
            "WorkloadId": workload_id,
            "MilestoneName": milestone_name,
            "ClientRequestToken": client_request_token,
        },
    )


async def get(hub, ctx, workload_id: str, milestone_number: int) -> Dict:
    r"""
    **Autogenerated function**

    Get a milestone for an existing workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        milestone_number(int): The milestone number. A workload can have a maximum of 100 milestones.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.milestone.get(
                ctx, workload_id=value, milestone_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.milestone.get workload_id=value, milestone_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="get_milestone",
        op_kwargs={"WorkloadId": workload_id, "MilestoneNumber": milestone_number},
    )


async def list_all(
    hub, ctx, workload_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List all milestones for an existing workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.milestone.list_all(ctx, workload_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.milestone.list_all workload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_milestones",
        op_kwargs={
            "WorkloadId": workload_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
