"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, lens_alias: str, base_lens_version: str) -> Dict:
    r"""
    **Autogenerated function**

    Get lens version differences.

    Args:
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        base_lens_version(str): The base version of the lens.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.version_difference.get(
                ctx, lens_alias=value, base_lens_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.version_difference.get lens_alias=value, base_lens_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="get_lens_version_difference",
        op_kwargs={"LensAlias": lens_alias, "BaseLensVersion": base_lens_version},
    )
