"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, workload_id: str, lens_alias: str, milestone_number: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Get lens review report.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        milestone_number(int, optional): The milestone number. A workload can have a maximum of 100 milestones. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.review.report.get(
                ctx, workload_id=value, lens_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.review.report.get workload_id=value, lens_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="get_lens_review_report",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "MilestoneNumber": milestone_number,
        },
    )
