"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, workload_id: str, lens_alias: str, milestone_number: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Get lens review.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        milestone_number(int, optional): The milestone number. A workload can have a maximum of 100 milestones. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.review.init.get(
                ctx, workload_id=value, lens_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.review.init.get workload_id=value, lens_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="get_lens_review",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "MilestoneNumber": milestone_number,
        },
    )


async def list_all(
    hub,
    ctx,
    workload_id: str,
    milestone_number: int = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List lens reviews.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        milestone_number(int, optional): The milestone number. A workload can have a maximum of 100 milestones. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.review.init.list_all(
                ctx, workload_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.review.init.list_all workload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_lens_reviews",
        op_kwargs={
            "WorkloadId": workload_id,
            "MilestoneNumber": milestone_number,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    workload_id: str,
    lens_alias: str,
    lens_notes: str = None,
    pillar_notes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update lens review.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        lens_notes(str, optional): The notes associated with the workload. Defaults to None.
        pillar_notes(Dict, optional): List of pillar notes of a lens review in a workload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.review.init.update(
                ctx, workload_id=value, lens_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.review.init.update workload_id=value, lens_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="update_lens_review",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "LensNotes": lens_notes,
            "PillarNotes": pillar_notes,
        },
    )


async def upgrade(
    hub,
    ctx,
    workload_id: str,
    lens_alias: str,
    milestone_name: str,
    client_request_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Upgrade lens review.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        milestone_name(str): The name of the milestone in a workload. Milestone names must be unique within a workload.
        client_request_token(str, optional): A unique case-sensitive string used to ensure that this request is idempotent (executes only once). You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.   This token is listed as required, however, if you do not specify it, the AWS SDKs automatically generate one for you. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the request will fail. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.review.init.upgrade(
                ctx, workload_id=value, lens_alias=value, milestone_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.review.init.upgrade workload_id=value, lens_alias=value, milestone_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="upgrade_lens_review",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "MilestoneName": milestone_name,
            "ClientRequestToken": client_request_token,
        },
    )
