"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    workload_id: str,
    lens_alias: str,
    pillar_id: str = None,
    milestone_number: int = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List lens review improvements.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        pillar_id(str, optional): The ID used to identify a pillar, for example, security. A pillar is identified by its PillarReviewSummary$PillarId. Defaults to None.
        milestone_number(int, optional): The milestone number. A workload can have a maximum of 100 milestones. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.review.improvement.list_all(
                ctx, workload_id=value, lens_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.review.improvement.list_all workload_id=value, lens_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_lens_review_improvements",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "PillarId": pillar_id,
            "MilestoneNumber": milestone_number,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
