"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, workload_id: str, lens_aliases: List) -> None:
    r"""
    **Autogenerated function**

    Associate a lens to a workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_aliases(List): List of lens aliases to associate or disassociate with a workload. Identify a lens using its LensSummary$LensAlias.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.init.associate(
                ctx, workload_id=value, lens_aliases=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.init.associate workload_id=value, lens_aliases=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="associate_lenses",
        op_kwargs={"WorkloadId": workload_id, "LensAliases": lens_aliases},
    )


async def disassociate(hub, ctx, workload_id: str, lens_aliases: List) -> None:
    r"""
    **Autogenerated function**

    Disassociate a lens from a workload.  The AWS Well-Architected Framework lens (wellarchitected) cannot be removed from a workload.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_aliases(List): List of lens aliases to associate or disassociate with a workload. Identify a lens using its LensSummary$LensAlias.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.init.disassociate(
                ctx, workload_id=value, lens_aliases=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.init.disassociate workload_id=value, lens_aliases=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="disassociate_lenses",
        op_kwargs={"WorkloadId": workload_id, "LensAliases": lens_aliases},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    List the available lenses.

    Args:
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.lens.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.lens.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_lenses",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
