"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    workload_id: str,
    lens_alias: str,
    question_id: str,
    milestone_number: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get the answer to a specific question in a workload review.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        question_id(str): The ID of the question.
        milestone_number(int, optional): The milestone number. A workload can have a maximum of 100 milestones. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.answer.get(
                ctx, workload_id=value, lens_alias=value, question_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.answer.get workload_id=value, lens_alias=value, question_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="get_answer",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "QuestionId": question_id,
            "MilestoneNumber": milestone_number,
        },
    )


async def list_all(
    hub,
    ctx,
    workload_id: str,
    lens_alias: str,
    pillar_id: str = None,
    milestone_number: int = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List of answers.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        pillar_id(str, optional): The ID used to identify a pillar, for example, security. A pillar is identified by its PillarReviewSummary$PillarId. Defaults to None.
        milestone_number(int, optional): The milestone number. A workload can have a maximum of 100 milestones. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.answer.list_all(
                ctx, workload_id=value, lens_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.answer.list_all workload_id=value, lens_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="list_answers",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "PillarId": pillar_id,
            "MilestoneNumber": milestone_number,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    workload_id: str,
    lens_alias: str,
    question_id: str,
    selected_choices: List = None,
    choice_updates: Dict = None,
    notes: str = None,
    is_applicable: bool = None,
    reason: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update the answer to a specific question in a workload review.

    Args:
        workload_id(str): The ID assigned to the workload. This ID is unique within an AWS Region.
        lens_alias(str): The alias of the lens, for example, serverless. Each lens is identified by its LensSummary$LensAlias.
        question_id(str): The ID of the question.
        selected_choices(List, optional): List of selected choice IDs in a question answer. The values entered replace the previously selected choices. Defaults to None.
        choice_updates(Dict, optional): A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated. Defaults to None.
        notes(str, optional): The notes associated with the workload. Defaults to None.
        is_applicable(bool, optional): Defines whether this question is applicable to a lens review. Defaults to None.
        reason(str, optional): The reason why a question is not applicable to your workload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wellarchitected.answer.update(
                ctx, workload_id=value, lens_alias=value, question_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wellarchitected.answer.update workload_id=value, lens_alias=value, question_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wellarchitected",
        operation="update_answer",
        op_kwargs={
            "WorkloadId": workload_id,
            "LensAlias": lens_alias,
            "QuestionId": question_id,
            "SelectedChoices": selected_choices,
            "ChoiceUpdates": choice_updates,
            "Notes": notes,
            "IsApplicable": is_applicable,
            "Reason": reason,
        },
    )
