"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, web_acl_arn: str, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call UpdateDistribution, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see UpdateDistribution.

    Args:
        web_acl_arn(str): The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to associate with the web ACL.  The ARN must be in one of the following formats:   For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id     For an Amazon API Gateway REST API: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name     For an AppSync GraphQL API: arn:aws:appsync:region:account-id:apis/GraphQLApiId    .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.associate(
                ctx, web_acl_arn=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.associate web_acl_arn=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="associate_web_acl",
        op_kwargs={"WebACLArn": web_acl_arn, "ResourceArn": resource_arn},
    )


async def create(
    hub,
    ctx,
    name: str,
    scope: str,
    default_action: Dict,
    visibility_config: Dict,
    description: str = None,
    rules: List = None,
    tags: List = None,
    custom_response_bodies: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a WebACL per the specifications provided.  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API.

    Args:
        name(str): The name of the web ACL. You cannot change the name of a web ACL after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        default_action(Dict): The action to perform if none of the Rules contained in the WebACL match. .
        description(str, optional): A description of the web ACL that helps with identification. . Defaults to None.
        rules(List, optional): The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. . Defaults to None.
        visibility_config(Dict): Defines and enables Amazon CloudWatch metrics and web request sample collection. .
        tags(List, optional): An array of key:value pairs to associate with the resource. Defaults to None.
        custom_response_bodies(Dict, optional): A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.  For information about customizing web requests and responses, see Customizing web requests and responses in WAF in the WAF Developer Guide.  For information about the limits on count and size for custom request and response settings, see WAF quotas in the WAF Developer Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.create(
                ctx, name=value, scope=value, default_action=value, visibility_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.create name=value, scope=value, default_action=value, visibility_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="create_web_acl",
        op_kwargs={
            "Name": name,
            "Scope": scope,
            "DefaultAction": default_action,
            "Description": description,
            "Rules": rules,
            "VisibilityConfig": visibility_config,
            "Tags": tags,
            "CustomResponseBodies": custom_response_bodies,
        },
    )


async def delete(hub, ctx, name: str, scope: str, id_: str, lock_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified WebACL. You can only use this if ManagedByFirewallManager is false in the specified WebACL.

    Args:
        name(str): The name of the web ACL. You cannot change the name of a web ACL after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.delete(
                ctx, name=value, scope=value, id_=value, lock_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.delete name=value, scope=value, id_=value, lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="delete_web_acl",
        op_kwargs={"Name": name, "Scope": scope, "Id": id_, "LockToken": lock_token},
    )


async def disassociate(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a web ACL from a regional application resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call UpdateDistribution. For information, see UpdateDistribution.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL.  The ARN must be in one of the following formats:   For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id     For an Amazon API Gateway REST API: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name     For an AppSync GraphQL API: arn:aws:appsync:region:account-id:apis/GraphQLApiId    .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.disassociate(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.disassociate resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="disassociate_web_acl",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def get(hub, ctx, name: str, scope: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified WebACL.

    Args:
        name(str): The name of the web ACL. You cannot change the name of a web ACL after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.get(ctx, name=value, scope=value, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.get name=value, scope=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="get_web_acl",
        op_kwargs={"Name": name, "Scope": scope, "Id": id_},
    )


async def list_all(
    hub, ctx, scope: str, next_marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an array of WebACLSummary objects for the web ACLs that you manage.

    Args:
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        next_marker(str, optional): When you request a list of objects with a Limit setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a NextMarker value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request. Defaults to None.
        limit(int, optional): The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a NextMarker value that you can use in a subsequent call to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.list_all(ctx, scope=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.list_all scope=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="list_web_acls",
        op_kwargs={"Scope": scope, "NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub,
    ctx,
    name: str,
    scope: str,
    id_: str,
    default_action: Dict,
    visibility_config: Dict,
    lock_token: str,
    description: str = None,
    rules: List = None,
    custom_response_bodies: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified WebACL.  This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling GetWebACL, update the settings as needed, and then provide the complete web ACL specification to this call.   A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API.

    Args:
        name(str): The name of the web ACL. You cannot change the name of a web ACL after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        default_action(Dict): The action to perform if none of the Rules contained in the WebACL match. .
        description(str, optional): A description of the web ACL that helps with identification. . Defaults to None.
        rules(List, optional): The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. . Defaults to None.
        visibility_config(Dict): Defines and enables Amazon CloudWatch metrics and web request sample collection. .
        lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .
        custom_response_bodies(Dict, optional): A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.  For information about customizing web requests and responses, see Customizing web requests and responses in WAF in the WAF Developer Guide.  For information about the limits on count and size for custom request and response settings, see WAF quotas in the WAF Developer Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.init.update(
                ctx,
                name=value,
                scope=value,
                id_=value,
                default_action=value,
                visibility_config=value,
                lock_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.init.update name=value, scope=value, id_=value, default_action=value, visibility_config=value, lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="update_web_acl",
        op_kwargs={
            "Name": name,
            "Scope": scope,
            "Id": id_,
            "DefaultAction": default_action,
            "Description": description,
            "Rules": rules,
            "VisibilityConfig": visibility_config,
            "LockToken": lock_token,
            "CustomResponseBodies": custom_response_bodies,
        },
    )
