"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the WebACL for the specified resource.

    Args:
        resource_arn(str): The ARN (Amazon Resource Name) of the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.web_acl.for_resource.get(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.web_acl.for_resource.get resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="get_web_acl_for_resource",
        op_kwargs={"ResourceArn": resource_arn},
    )
