"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    web_acl_arn: str,
    rule_metric_name: str,
    scope: str,
    time_window: Dict,
    max_items: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.  GetSampledRequests returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, GetSampledRequests returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.

    Args:
        web_acl_arn(str): The Amazon resource name (ARN) of the WebACL for which you want a sample of requests.
        rule_metric_name(str): The metric name assigned to the Rule or RuleGroup for which you want a sample of requests.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        time_window(Dict): The start date and time and the end date and time of the range for which you want GetSampledRequests to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.
        max_items(int): The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of MaxItems, GetSampledRequests returns information about all of them. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.sampled_request.get_all(
                ctx,
                web_acl_arn=value,
                rule_metric_name=value,
                scope=value,
                time_window=value,
                max_items=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.sampled_request.get_all web_acl_arn=value, rule_metric_name=value, scope=value, time_window=value, max_items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="get_sampled_requests",
        op_kwargs={
            "WebAclArn": web_acl_arn,
            "RuleMetricName": rule_metric_name,
            "Scope": scope,
            "TimeWindow": time_window,
            "MaxItems": max_items,
        },
    )
