"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, web_acl_arn: str, resource_type: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call ListDistributionsByWebACLId.

    Args:
        web_acl_arn(str): The Amazon Resource Name (ARN) of the web ACL.
        resource_type(str, optional): Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.resource.for_web_acl.list(ctx, web_acl_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.resource.for_web_acl.list web_acl_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="list_resources_for_web_acl",
        op_kwargs={"WebACLArn": web_acl_arn, "ResourceType": resource_type},
    )
