"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "regex_pattern_set"


async def create(
    hub,
    ctx,
    name: str,
    scope: str,
    regular_expression_list: List,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.

    Args:
        name(str): The name of the set. You cannot change the name after you create the set.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        description(str, optional): A description of the set that helps with identification. . Defaults to None.
        regular_expression_list(List): Array of regular expression strings. .
        tags(List, optional): An array of key:value pairs to associate with the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.regex_pattern_set_.create(
                ctx, name=value, scope=value, regular_expression_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.regex_pattern_set.create name=value, scope=value, regular_expression_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="create_regex_pattern_set",
        op_kwargs={
            "Name": name,
            "Scope": scope,
            "Description": description,
            "RegularExpressionList": regular_expression_list,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str, scope: str, id_: str, lock_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified RegexPatternSet.

    Args:
        name(str): The name of the set. You cannot change the name after you create the set.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.regex_pattern_set_.delete(
                ctx, name=value, scope=value, id_=value, lock_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.regex_pattern_set.delete name=value, scope=value, id_=value, lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="delete_regex_pattern_set",
        op_kwargs={"Name": name, "Scope": scope, "Id": id_, "LockToken": lock_token},
    )


async def get(hub, ctx, name: str, scope: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified RegexPatternSet.

    Args:
        name(str): The name of the set. You cannot change the name after you create the set.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.regex_pattern_set_.get(
                ctx, name=value, scope=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.regex_pattern_set.get name=value, scope=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="get_regex_pattern_set",
        op_kwargs={"Name": name, "Scope": scope, "Id": id_},
    )


async def list_all(
    hub, ctx, scope: str, next_marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage.

    Args:
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        next_marker(str, optional): When you request a list of objects with a Limit setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a NextMarker value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request. Defaults to None.
        limit(int, optional): The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a NextMarker value that you can use in a subsequent call to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.regex_pattern_set_.list_all(ctx, scope=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.regex_pattern_set.list_all scope=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="list_regex_pattern_sets",
        op_kwargs={"Scope": scope, "NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub,
    ctx,
    name: str,
    scope: str,
    id_: str,
    regular_expression_list: List,
    lock_token: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified RegexPatternSet.  This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling GetRegexPatternSet, update the settings as needed, and then provide the complete regex pattern set specification to this call.

    Args:
        name(str): The name of the set. You cannot change the name after you create the set.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        description(str, optional): A description of the set that helps with identification. . Defaults to None.
        regular_expression_list(List): .
        lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.regex_pattern_set_.update(
                ctx,
                name=value,
                scope=value,
                id_=value,
                regular_expression_list=value,
                lock_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.regex_pattern_set.update name=value, scope=value, id_=value, regular_expression_list=value, lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="update_regex_pattern_set",
        op_kwargs={
            "Name": name,
            "Scope": scope,
            "Id": id_,
            "Description": description,
            "RegularExpressionList": regular_expression_list,
            "LockToken": lock_token,
        },
    )
