"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, scope: str, web_acl_name: str, web_acl_id: str, rule_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the keys that are currently blocked by a rate-based rule. The maximum number of managed keys that can be blocked for a single rate-based rule is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.

    Args:
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        web_acl_name(str): The name of the web ACL. You cannot change the name of a web ACL after you create it.
        web_acl_id(str): The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        rule_name(str): The name of the rate-based rule to get the keys for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.rate_based_statement_managed_key.get_all(
                ctx, scope=value, web_acl_name=value, web_acl_id=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.rate_based_statement_managed_key.get_all scope=value, web_acl_name=value, web_acl_id=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="get_rate_based_statement_managed_keys",
        op_kwargs={
            "Scope": scope,
            "WebACLName": web_acl_name,
            "WebACLId": web_acl_id,
            "RuleName": rule_name,
        },
    )
