"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, vendor_name: str, name: str, scope: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides high-level information for a managed rule group, including descriptions of the rules.

    Args:
        vendor_name(str): The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
        name(str): The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.managed_rule_group.describe(
                ctx, vendor_name=value, name=value, scope=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.managed_rule_group.describe vendor_name=value, name=value, scope=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="describe_managed_rule_group",
        op_kwargs={"VendorName": vendor_name, "Name": name, "Scope": scope},
    )
