"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "ip_set"


async def create(
    hub,
    ctx,
    name: str,
    scope: str,
    ip_address_version: str,
    addresses: List,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.

    Args:
        name(str): The name of the IP set. You cannot change the name of an IPSet after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        description(str, optional): A description of the IP set that helps with identification. . Defaults to None.
        ip_address_version(str): Specify IPV4 or IPV6. .
        addresses(List): Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.  Examples:    To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32.   To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.   To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.   To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64.   For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing.
        tags(List, optional): An array of key:value pairs to associate with the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.ip_set_.create(
                ctx, name=value, scope=value, ip_address_version=value, addresses=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.ip_set.create name=value, scope=value, ip_address_version=value, addresses=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="create_ip_set",
        op_kwargs={
            "Name": name,
            "Scope": scope,
            "Description": description,
            "IPAddressVersion": ip_address_version,
            "Addresses": addresses,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str, scope: str, id_: str, lock_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified IPSet.

    Args:
        name(str): The name of the IP set. You cannot change the name of an IPSet after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.ip_set_.delete(
                ctx, name=value, scope=value, id_=value, lock_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.ip_set.delete name=value, scope=value, id_=value, lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="delete_ip_set",
        op_kwargs={"Name": name, "Scope": scope, "Id": id_, "LockToken": lock_token},
    )


async def get(hub, ctx, name: str, scope: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified IPSet.

    Args:
        name(str): The name of the IP set. You cannot change the name of an IPSet after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.ip_set_.get(ctx, name=value, scope=value, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.ip_set.get name=value, scope=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="get_ip_set",
        op_kwargs={"Name": name, "Scope": scope, "Id": id_},
    )


async def list_all(
    hub, ctx, scope: str, next_marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an array of IPSetSummary objects for the IP sets that you manage.

    Args:
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        next_marker(str, optional): When you request a list of objects with a Limit setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a NextMarker value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request. Defaults to None.
        limit(int, optional): The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a NextMarker value that you can use in a subsequent call to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.ip_set_.list_all(ctx, scope=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.ip_set.list_all scope=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="list_ip_sets",
        op_kwargs={"Scope": scope, "NextMarker": next_marker, "Limit": limit},
    )


async def update(
    hub,
    ctx,
    name: str,
    scope: str,
    id_: str,
    addresses: List,
    lock_token: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified IPSet.   This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling GetIPSet, update the settings as needed, and then provide the complete IP set specification to this call.

    Args:
        name(str): The name of the IP set. You cannot change the name of an IPSet after you create it.
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        id_(str): A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
        description(str, optional): A description of the IP set that helps with identification. . Defaults to None.
        addresses(List): Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.  Examples:    To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32.   To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.   To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.   To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64.   For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing.
        lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.ip_set_.update(
                ctx, name=value, scope=value, id_=value, addresses=value, lock_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.ip_set.update name=value, scope=value, id_=value, addresses=value, lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="update_ip_set",
        op_kwargs={
            "Name": name,
            "Scope": scope,
            "Id": id_,
            "Description": description,
            "Addresses": addresses,
            "LockToken": lock_token,
        },
    )
