"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(hub, ctx, web_acl_arn: str, web_acl_lock_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.  You can only use this if ManagedByFirewallManager is false in the specified WebACL.

    Args:
        web_acl_arn(str): The Amazon Resource Name (ARN) of the web ACL.
        web_acl_lock_token(str): A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.firewall_manager_rule_group.delete_multiple(
                ctx, web_acl_arn=value, web_acl_lock_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.firewall_manager_rule_group.delete_multiple web_acl_arn=value, web_acl_lock_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="delete_firewall_manager_rule_groups",
        op_kwargs={"WebACLArn": web_acl_arn, "WebACLLockToken": web_acl_lock_token},
    )
