"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, scope: str, next_marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and the Marketplace managed rule groups that you're subscribed to.

    Args:
        scope(str): Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.  To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:    CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.    API and SDKs - For all calls, use the Region endpoint us-east-1.   .
        next_marker(str, optional): When you request a list of objects with a Limit setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a NextMarker value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request. Defaults to None.
        limit(int, optional): The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a NextMarker value that you can use in a subsequent call to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.wafv2.available_managed_rule_group.list_all(ctx, scope=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.wafv2.available_managed_rule_group.list_all scope=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="wafv2",
        operation="list_available_managed_rule_groups",
        op_kwargs={"Scope": scope, "NextMarker": next_marker, "Limit": limit},
    )
