"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, web_acl_id: str, rule_id: str, time_window: Dict, max_items: int
) -> Dict:
    r"""
    **Autogenerated function**

     This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for regional and global use.   Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from among the first 5,000 requests that your AWS resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.  GetSampledRequests returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, GetSampledRequests returns an updated time range. This new time range indicates the actual period during which AWS WAF selected the requests in the sample.

    Args:
        web_acl_id(str): The WebACLId of the WebACL for which you want GetSampledRequests to return a sample of requests.
        rule_id(str):  RuleId is one of three values:   The RuleId of the Rule or the RuleGroupId of the RuleGroup for which you want GetSampledRequests to return a sample of requests.    Default_Action, which causes GetSampledRequests to return a sample of the requests that didn't match any of the rules in the specified WebACL.  .
        time_window(Dict): The start date and time and the end date and time of the range for which you want GetSampledRequests to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". You can specify any time range in the previous three hours.
        max_items(int): The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received during the time range. If your resource received fewer requests than the value of MaxItems, GetSampledRequests returns information about all of them. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.waf_regional.sampled_request.get_all(
                ctx, web_acl_id=value, rule_id=value, time_window=value, max_items=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.waf_regional.sampled_request.get_all web_acl_id=value, rule_id=value, time_window=value, max_items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="waf-regional",
        operation="get_sampled_requests",
        op_kwargs={
            "WebAclId": web_acl_id,
            "RuleId": rule_id,
            "TimeWindow": time_window,
            "MaxItems": max_items,
        },
    )
